%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% This work by EPFL STI IBI LBNI is licensed under 
% a Creative Commons Attribution-NonCommercial-ShareAlike 3.0 Unported License.
% Based on a work at http://lbni.epfl.ch/.
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%


[Filename, ImageDir]        = uigetfile(    {'*.txt','Nanoscope Files (*.txt)'}, ...                                                % Allows for user selection of the images to process
                                        'Pick a file',...
                                        '/Users/berick/Documents/EPFL/J Scanner Calibration/',...                                                         % Default starting directory.  Useful to change depending on where files are saved
                                        'MultiSelect','on');  


                                    
%% Prep for file output
mkdir([ImageDir,'Matlab',filesep,'Figure Jpegs',filesep]);                                                                                       % Makes a new directory for the final jpeg output
mkdir([ImageDir,'Matlab',filesep,'Figure Figs',filesep]);                                                                                        % Makes a new directory for the final fig output
mkdir([ImageDir,'Matlab',filesep,'Figure Fig',filesep]);


%% Setup inmport paramters
Filename_length = length(Filename);
searchstring(1).label='@2:Z scale:';            %Need to find new param
searchstring(2).label='xPixel     :';
searchstring(3).label='yPixel     :';
searchstring(4).label='Data offset';            %Need to find new param 
searchstring(5).label='Image Data:';            %Need to find new param
searchstring(6).label='XScanRange :';
searchstring(7).label='@Sens. Zsens:';          %Need to find new param
searchstring(8).label='@Z magnify:';            %Need to find new param

searchstring(9).label='Speed      :';
searchstring(10).label='@Sens. DeflSens: V';    %Need to find new param
searchstring(11).label='LockInFreq         :';
searchstring(12).label='LockInAmpl         :';
searchstring(13).label='SetPoint         :';
searchstring(14).label='@Sens. Zsens: V';       %Need to find new param
searchstring(15).label='FileName :'; 
searchstring(16).label='Time :'; 
searchstring(17).label='Caption  :'; 
searchstring(18).label='Scale    :'; 
searchstring(19).label='PhysUnit :'; 


%Init_poly_coef              = cell(length(Filename),length(channels_flatten));
%Init_poly_coef_1st_med      = cell(length(Filename),length(channels_flatten));
%Init_poly_coef_1st_nomed    = cell(length(Filename),length(channels_flatten));
%Init_poly_coef_2nd_med      = cell(length(Filename),length(channels_flatten));
%Init_poly_coef_2nd_nomed    = cell(length(Filename),length(channels_flatten));
%Second_poly_coef            = cell(length(Filename),length(channels_flatten));
%Third_poly_coef             = cell(length(Filename),length(channels_flatten));
%min_spacing_stdev           = zeros(Filename_length,channels_nb);
%max_spacing_stdev           = zeros(Filename_length,channels_nb);


for index = 1:Filename_length                                                                                               % Loops through the number of files
    file_name = [ImageDir,Filename{index}];

    
    %% Read Paramter File
        fid = fopen(file_name,'r');
        [message,errnum] = ferror(fid);
        if(errnum)
            fprintf(1,'I/O Error %d \t %s',[errnum,message]);
            %   break
        end
        header_end=0; eof = 0; counter = 1; byte_location = 0;
        nstrings=size(searchstring,2);
        parcounter = ones(nstrings,1);
        parameters = struct('values',cell(1,nstrings));

        for ij=1:nstrings 
            parcounter(ij)=1; 
        end;

        while( and( ~eof, ~header_end ) )

        byte_location = ftell(fid);  
        line = fgets(fid);

        for ij=1:nstrings
            if strfind(line,searchstring(ij).label)
                [place_holder remain] = strtok(line,':');
                parameters(ij).values{parcounter(ij),1} = remain;
                parcounter(ij)=parcounter(ij)+1;
            end
        end;

        if( (-1)==line )  
            eof  = 1;  
        end

        if ~isempty( strfind( line, '\*File list end' ) ) 
            header_end = 1;   
        end

        counter=counter+1;
        end
        
    fclose(fid);


    param           = parameters;
    scaling         = 0;%str2num(param(1).values{2}(2:end));                                                                                                                                                 % Scaling parameters
    spl             = str2num(param(2).values{1}(2:end));                                                                                                                                                 % Samples per line
    linno           = str2num(param(3).values{1}(2:end));                                                                                                                                                 % No of lines 
    image_pos       = 0;%str2num(param(4).values{1}(2:end));                                                                                                                                                 % Data position
    ScanSize        = str2num(param(6).values{1}(2:end));
    Z_Sensitivity   = 0;%str2num(param(7).values{1}(2:end));                                                                                                                                                 % Data position
    Z_Magnification = 0;%str2num(param(8).values{1}(2:end));                                                                                                                                                 % Zmagnification
    
    Scan_Rate       = str2num(strtok(param(9).values{1}(2:end),';'))/2;
    Defl_Sens       = 0;%str2num(param(10).values{1}(2:end));
    Drive_Freq      = str2num(param(11).values{1}(2:end));
    Drive_Amp       = str2num(param(12).values{1}(2:end));
    Amp_Set_Point   = str2num(param(13).values{1}(2:end))*str2num(param(12).values{1}(2:end))/100;
    Z_sensor_sens   = 0;%str2num(param(14).values{1}(2:end));
    Time            = param(16).values{1}(2:end);
    [tok remain]    = strtok(Filename{index},',.');
    file_number     = str2double(remain(2:3));
    
    Image_Data_File = [ImageDir,'Matlab',filesep,'Imaging_Parameters.txt'];
    Image_Time_File = [ImageDir,'Matlab',filesep,'Image_Time_Height.txt'];
    if  index == 1  
        fid = fopen(Image_Data_File, 'a');
        fprintf(fid, [  'File Number','\t',...
                        'Samples per Line','\t',...
                        'Lines per Image','\t',...
                        'Scan Rate (Hz)','\t',...
                        'Deflection Sensitivity (nm/V)','\t',...
                        'Drive Frequency (kHz)','\t',...
                        'Drive Amplitude (mV)','\t',...
                        'Amplitude Setpoint (mV)','\n'],...
                        'char');
                    
        fprintf(fid, [  num2str(file_number,'%0.0f'),'\t',...
                        num2str(spl(1),'%0.0f'),'\t',...
                        num2str(linno,'%0.0f'),'\t',...
                        num2str(Scan_Rate,'%0.3f'),'\t',...
                        num2str(Defl_Sens,'%0.3f'),'\t',...
                        num2str(Drive_Freq,'%0.2f'),'\t',...
                        num2str(Drive_Amp,'%0.2f'),'\t',...
                        num2str(Amp_Set_Point,'%0.2f'),'\n'],...
                        'char');
        fclose(fid);
        
        gid = fopen(Image_Time_File, 'a');
        fprintf(gid, [  'File Number','\t',...
                        'File Time','\t',...
                        'Height 1','\t',...
                        'StDev 1','\t',...
                        'Height 2','\t',...
                        'StDev 2','\n'],...
                        'char');

        fclose(gid);
        
        
    else
        fid = fopen(Image_Data_File, 'a');
        fprintf(fid, [  num2str(file_number,'%0.0f'),'\t',...
                        num2str(spl(1),'%0.0f'),'\t',...
                        num2str(linno,'%0.0f'),'\t',...
                        num2str(Scan_Rate,'%0.3f'),'\t',...
                        num2str(Defl_Sens,'%0.3f'),'\t',...
                        num2str(Drive_Freq,'%0.2f'),'\t',...
                        num2str(Drive_Amp,'%0.2f'),'\t',...
                        num2str(Amp_Set_Point,'%0.2f'),'\n'],...
                        'char');
        fclose(fid);
    end
    
%% Import Data Channels
    L = length(param(15).values);                                                                                                                                                             % Sets the number of image channels
    channel_info = struct('Trace',cell(L,1),'Name',cell(L,1),'Finalscaling',cell(L,1),'Unit',cell(L,1));
    finalscaling = zeros(L,1);
    for im=1:L                                                                                                                                                                         % Loops for the number of channels
        if  strfind(param(17).values{im},'Fwd')>0
            channel_info(im).Trace  = char('Trace');                                                                                          % Determines if Channel is Trace or Retrace
        else
            channel_info(im).Trace=char('Retrace');
        end
        channel_info(im).Name               = param(17).values{im}(6:end);
        channel_info(im).Finalscaling       = str2double(param(18).values{im}(3:end));                                                                                                     % Computes some of the scaling paramters
        finalscaling(im)                    = str2double(param(18).values{im}(3:end));
        channel_info(im).Unit               = param(19).values{im}(3:end);
        
        mkdir([ImageDir,'Matlab',filesep,'Figure Jpegs',filesep,channel_info(im).Name,filesep]);
        mkdir([ImageDir,'Matlab',filesep,'Figure Jpegs',filesep,channel_info(im).Name,filesep,'hist',filesep]);
        mkdir([ImageDir,'Matlab',filesep,'Figure Jpegs',filesep,channel_info(im).Name,filesep,'grey',filesep]);
        mkdir([ImageDir,'Matlab',filesep,'Figure Jpegs',filesep,channel_info(im).Name,filesep,'text',filesep]);
        
                
    end;   
    
%     if S.processAll  == 0        % Process one image
%        %disp({['Image ',num2str(index),' of 1'];['Z Sensitivity ',num2str(Z_Sensitivity)];['Hard Scaling ',num2str(scaling)];['Final Scaling ',num2str(finalscaling(1))]});    % Displays progress and scaling 
%        disp(['Image ',num2str(index),' of 1']);    % Displays progress and scaling 
%     else
%        %disp({['Image ',num2str(index),' of ',num2str(length(Filename))];['Z Sensitivity ',num2str(Z_Sensitivity)];['Hard Scaling ',num2str(scaling)];['Final Scaling ',num2str(finalscaling(1))]});    % Displays progress and scaling  
%        disp(['Image ',num2str(index),' of ',num2str(length(Filename))]);    % Displays progress and scaling  
%     end


    images = zeros(linno, spl, L);
    for i = 1:L
       clear A
       file_name_test   = param(15).values{i}(3:end);
       fid              = fopen(strcat(ImageDir,file_name_test),'r'); 
       A                = fread(fid, [spl linno],'int32');
       images(:,:,i)    = flipud(rot90(finalscaling(i)*A));
       fclose(fid);
    end;
    
    
    images(:,:,i)               = images(:,:,i)-median(reshape(images(:,:,i),size(images,1)*size(images,2),1));
end

imshow(images(:,:,1),[min(min(images(:,:,1))) max(max(images(:,:,1)))])
